package gov.va.genisis2.exceptions;

/**
 * Holds all the error messages used by the Genisis application
 *  
 * @author Prasad Thummalapalli
 * @author Getaneh Kassahun
 *
 */
public enum ErrorEnum {
	USER_DAO_EXP_GETUSERDETAILSBYEMAIL("Exception occured while querying getUserDetailsByEmail."),
	USER_DAO_EXP_STUDYAPPROVALBYTITLE("Exception occured while querying getStudyApprovalsByTitle."),
	USER_DAO_EXP_GETUSERDETAILSBYID("Exception occured while querying getUserDetailsById."),
	USER_DAO_EXP_GETUSERROLE("Exception occured while querying getUserRole."),
	USER_DAO_EXP_GETUSERDETAILSBYUSERNAME("Exception occured while querying getUserDetailsByUsername."),
	USER_DAO_EXP_GETALLUSERS("Exception occured while querying getAllUsers."),
	USER_DAO_EXP_GETLATESTUSERREFRESHHISTORY("Exception occured while querying getLatestUserRefreshHistory."),
	USER_DAO_EXP_GETUSERCOUNTONROLE("Exception occured while querying getUserCountOnRole."),
	REQUEST_DAO_EXP_GETREQUESTSTATUSCOUNTS("Exception occured while querying getRequestStatusCounts."),
	REQUEST_DAO_EXP_GETWORKFLOWSTATUS("Exception occured while querying getWorkflowStatus."),
	USER_DAO_EXP_GETUSERDETAILSBYROLEID("Exception occured while querying getUserDetailsByRoleId."),
	USER_DAO_EXP_UPDATESTATUS("Exception occured while update user status to disabled"),
	USERROLETYPE_DAO_EXP_GETUSERROLETYPE("Exception occured while querying getUserRoleTypeByUserId. userId {}"),
	USER_ROLETYPES_IS_NULL("userRoleTypes is null for userId: {}"),
	USER_ROLETYPE_IS_NULL("userRoleType is null for userId: {}"),
	ROLE_TYPE_IS_NULL("roleType is null for userId: {}"),
	USER_DAO_EXP_GETROLE("Error in getRole "),
	USERAPPROVERS_IS_NULL("UserApproversForUserId is null for userId: {}"),
	USERAPPROVER_IS_NULL("UserApprover is null for userId: {}"),
	USER_DAO_EXP_GETAPPROVER("Error in getApprover "),
	INVALID_ROLETYPEID("Invalid RoleTypeId "),
	EXCEPTION_OCCURED("Exception Occured. {}"),
	EXP_CTRL_GENISISVERSION("Error ocuured while getting GenisisApiVersion"),
	EXP_CTRL_TABLECOPY("Error ocuured while performing Table Copy"),
	EXP_CTRL_TABLECOPYDOMAINS("Error ocuured while getting Copy Table Domains"),
	EXP_CTRL_LDAPLASTREFRESH("Error ocuured while getting UserCounts and LdapLastRefresh"),
	EXP_CTRL_REQUESTSTATUSCOUNTS("Error ocuured while getting Request Counts on Status"),
	EXP_CTRL_USERDATAREFRESH("Error ocuured while update user data"),
	EXP_CTRL_USERBYEMAIL("Error ocuured while getting User details for email {}"),
	EXP_CTRL_USERBYID("Error ocuured while getting User details for id {}"),
	EXP_CTRL_USERBYUID("Error ocuured while getting User details for uid {}"),
	EXP_CTRL_USERBYUSRNAME("Error ocuured while getting User details for username {}"),
	EXP_CTRL_CREATEREQUEST("Error ocuured while creating Request"),
	EXP_CTRL_GETREQUESTBYSA("Error ocuured to get  Requests by Study Approval"),
	EXP_CTRL_GETREQUESTBYID("Error ocuured to get  Requests by Request id {}"),
	EXP_CTRL_GETREQUESTBYUID("Error ocuured to get  Requests by uid {}"),
	EXP_CTRL_GETALLREQUESTS("Error ocuured getting all  Requests"),
	EXP_CTRL_GETREQUESTSDDM("Error ocuured while getting all  Requests by Data Manager: id {}"),
	EXP_CTRL_GETREQUESTSDSM("Error ocuured while getting all  Requests by Data Source Manager: id {}"),
	EXP_CTRL_GETREQUESTBYSTS("Error ocuured while getting all  Requests by Status: {}"),
	EXP_CTRL_UPDATEREQUEST("Error ocuured while updating Request Id: {}"),
	EXP_CTRL_SUBMITREQUEST("Error ocuured while Submitting Request Id: {}"),
	EXP_CTRL_UPDATE_REQUEST("Error ocuured while performing {} on Request Id: {}"),
	EXP_CTRL_SENTREQUEST("Error ocuured while approving Request Id: {}"),
	EXP_CTRL_DENYREQUEST("Error ocuured while denying Request Id: {}"),
	EXP_CTRL_RETURNREQUEST("Error ocuured while returning Request Id: {}"),
	EXP_CTRL_FULFILREQUEST("Error ocuured while Fulfilling Request Id: {}"),
	EXP_CTRL_UNFULFILREQUEST("Error ocuured while Rejecting (Unfulfillment) Request Id: {}"),
	EXP_CTRL_REJECTREQUEST("Error ocuured while rejecting Request Id: {}"),
	EXP_CTRL_ACCEPTDATA("Error ocuured while accepting Results Request Id: {}"),
	EXP_CTRL_DELIVERREQUEST("Error ocuured while Results Deliver Request Id: {}"),
	EXP_CTRL_CREATESA("Error ocuured while creating Study Approval"),
	EXP_CTRL_UPDATESA("Error ocuured while updating Study Approval "),
	EXP_CTRL_GETSA("Error ocuured while querring on getStudyApprovalById for id {}"),
	EXP_CTRL_GETSABYUID("Error ocuured while querring on getStudyApprovalByUser for uid {}"),
	EXP_CTRL_GETALLSAS("Error ocuured while querring on getAllStudyApprovals"),
	EXP_CTRL_CREATECOMMENT("Error ocuured while creating Comments"),
	EXP_CTRL_ACCEPT_FILE_ATTACHMENT("Error ocuured while attaching file"),
	EXP_CTRL_GETREQUESTTRACK("Error ocuured while tracking Request Id {}"),
	EXP_CTRL_GETDS("Error ocuured while getting Data Sources"),
	EXP_CTRL_TOOLTIP_DESCRIPTION("Error ocuured while getting Tooltip description"),
	EXP_CTRL_GETREQUESTTYPE("Error ocuured while getting Request Types"),
	EXP_CTRL_GETDATATYPE("Error ocuured while getting Data Types"),
	ERR_NO_RECORDS_FOUND("No records found"),
	USER_DOESNOT_EXIST("This user does not exist in the system"),
	ERR_GETREQUEST_ID("Exception occured while querying Requests on Id"),
	ERR_GETREQUESTHIST_IDSTS("Exception occured while querying Request History on Request Id and Status"),
	ERR_GETUSERS_BY_ROLEID("Exception occured while querying user details by roleId"),
	LDAP_USERREFRESH_FAILED("The importing of Genisis2 users has failed."),
	LDAP_STUDYAPPROVALFRESH_FAILED("The importing of Genisis2 study approval  has failed."),
	OPERATION_NOT_ALLOWED("Operation is not allowed"),
	ACTIVITI_EXP_HUMANTASK("ActivitiService.claimAndCompleteHumanTask: Unable to complete and Claim Human Task"),
	STUDYAPPROVAL_DAO_EXP_UPDATESTATUS("Exception occured while update studyApproval status to disabled"),
	LDAP_STUDYAPPROVAL_REFRESH_FAILED("The importing of Genisis2 study approval has failed."),
	INTERNAL_SYS_ERROR("Internal System error occurred. Please contact your Administrator.");
	
	private String errorMessage;
	
	private ErrorEnum() {
		
	}
	
	private ErrorEnum(String errorMessage) {
		this.errorMessage = errorMessage;
	}
	
	public String getErrorMessage() {
		return errorMessage;
	}
}
